$(document).ready(function(){
    
    /*
    var group = $("#group").val();
    var username = $("#nick_name").val();
    
    if(username && group) {
        
        var socket = io.connect(
            'http://localhost:3006',
            {
                transports : [ 'polling' ],
                query : {
                    "username":username,
                    "groupName":group
                }
            }
        );

        var group_Data ={
            username:username,
            groupName:group
        };

        // Add user to group
        socket.emit('addToGroup', group_Data);
        
        // Display message to chat list
        socket.on('updatechat', function(data) {

            if(data.groupName==group && data && typeof data.joined_message !== "undefined") {
                
                // Scroll to bottom of chat
                scrollToBottomChat();

                // Join Sound
                chat_sound('notification');

                // Show system message
                $('#messages').append('<li class="chatItem">'+data.joined_message+'</li>');

            }

        });

        socket.on('notify_chat_to_admin', function(data) {
            if( data && data.groupName == group ){
                
                // Scroll to bottom of chat
                scrollToBottomChat();

                // Play Chat Sound
                if( username !== data.username ){
                    chat_sound('chat-2');
                }

                // Show chat message
                $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.username+'</h6><div class="messageContainer">'+ data.messages+'</div><div class="time-lapsed" data-time="'+data.current_date+'">'+timeSince(data.current_date)+'</div></div><div class="clear"></div></li>');
            }
        });

        $('#chatForm').submit(function(e) {

            // prevents page reloading
            e.preventDefault();

            // Get Current Date
            const current_date = Date.now();

            // Get message from input field
            let userMsg = $('#txt').val();

            // Get userid
            let userid = $('body').attr('data-userid');

            // Check if message is not empty
            if(userMsg != ""){

                // Emit/Send message to server
                socket.emit(
                    'live_chat_message',
                    {
                        "sender_id":userid,
                        "messages":userMsg,
                        "username":username,
                        "groupName":group,
                        "current_date":current_date
                    }
                );

                // Reset input field
                $('#txt').val('');

                return false;
            
            // Else prevent users from sending empty messages
            }else{
                
                return false;

            }

        });

        var timeout;

        // Remove typing status
        function timeoutFunction() {
            typing = false;
            socket.emit(
                'typing',
                {
                    "username":username,
                    "groupName":group,
                    "status":false
                }
            );
        }
        
        // Add typing status when user is typing
        function isTyping() {
            typing = true;

            socket.emit(
                'typing',
                {
                    "username":username,
                    "groupName":group,
                    "status":true
                }
            );

            clearTimeout(timeout);

            timeout = setTimeout(timeoutFunction, 2000);

        }

        socket.on('typing', function(data) {

            // Remove previous typing status
            $('#typing').html("");
            
            // Display typing status
            if(data && data.groupName == group && data.username !=username && data.status==true){
                $('#typing').html('<i>' + data.username + ' is typing....</i>');
            }

        });

    }
    */

    function new_chat_connection(){

        var group = $("#group").val();
        var username = $("#nick_name").val();

        if( username != '' && group != '' ) {
            
            // Disconnect previous connection
            io.disconnect();

            var socket = io.connect(
                'http://localhost:3006',
                {
                    transports : [ 'polling' ],
                    query : {
                        "username":username,
                        "groupName":group
                    }
                }
            );
    
            var group_Data ={
                username:username,
                groupName:group
            };
    
            // Add user to group
            socket.emit('addToGroup', group_Data);
            
            // Display message to chat list
            socket.on('updatechat', function(data) {
    
                if(data.groupName==group && data && typeof data.joined_message !== "undefined") {
                    
                    // Scroll to bottom of chat
                    scrollToBottomChat();
    
                    // Join Sound
                    chat_sound('notification');
    
                    // Show system message
                    $('#messages').append('<li class="chatItem">'+data.joined_message+'</li>');
    
                }
    
            });
    
            socket.on('notify_chat_to_admin', function(data) {
                if( data && data.groupName == group ){
                    
                    // Scroll to bottom of chat
                    scrollToBottomChat();
    
                    // Play Chat Sound
                    if( username !== data.username ){
                        chat_sound('chat-2');
                    }
    
                    // Show chat message
                    $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.username+'</h6><div class="messageContainer">'+ data.messages+'</div><div class="time-lapsed" data-time="'+data.current_date+'">'+timeSince(data.current_date)+'</div></div><div class="clear"></div></li>');
                }
            });
    
            $('#chatForm').submit(function(e) {
    
                // prevents page reloading
                e.preventDefault();
    
                // Get Current Date
                const current_date = Date.now();
    
                // Get message from input field
                let userMsg = $('#txt').val();
    
                // Get userid
                let userid = $('body').attr('data-userid');
    
                // Check if message is not empty
                if(userMsg != ""){
    
                    // Emit/Send message to server
                    socket.emit(
                        'live_chat_message',
                        {
                            "sender_id":userid,
                            "messages":userMsg,
                            "username":username,
                            "groupName":group,
                            "current_date":current_date
                        }
                    );
    
                    // Reset input field
                    $('#txt').val('');
    
                    return false;
                
                // Else prevent users from sending empty messages
                }else{
                    
                    return false;
    
                }
    
            });
    
            var timeout;
    
            // Remove typing status
            function timeoutFunction() {
                typing = false;
                socket.emit(
                    'typing',
                    {
                        "username":username,
                        "groupName":group,
                        "status":false
                    }
                );
            }
            
            // Add typing status when user is typing
            function isTyping() {
                typing = true;
    
                socket.emit(
                    'typing',
                    {
                        "username":username,
                        "groupName":group,
                        "status":true
                    }
                );
    
                clearTimeout(timeout);
    
                timeout = setTimeout(timeoutFunction, 2000);
    
            }
    
            socket.on('typing', function(data) {
    
                // Remove previous typing status
                $('#typing').html("");
                
                // Display typing status
                if(data && data.groupName == group && data.username !=username && data.status==true){
                    $('#typing').html('<i>' + data.username + ' is typing....</i>');
                }
    
            });
    
        }

    }

    // Initialize chat connection
    new_chat_connection();

    // Open New Thread
    $('body').on('click', '.thread-item a', function() {
        
        var user_id = $(this).attr('data-user-id');
        var name = $(this).attr('data-name');

        new_chat_connection();

    });

});